//------------------------------------------------------
//M.Sc.Tobias Pfaff Version 1.0 - 05.04.2018
//LASERR-Treiber - das Projekt unterliegt der 
//GNU-OpenSource-Lezens und er CERN-Openhardware-Lizens 1.2 "cern_ohl_v_1_2.pdf"
//Verwendung auf eigene Gefahr.
//Eine komerzielle Nutzung bedarf der schriftlichen Erlaubnis des Autors
//Die private Nutzung ist erlaubnisfrei
//Zugehörige Hardware "SteuercontrollerAdafruitTFTShield.pdf"
//------------------------------------------------------

#define WATCHDOG
#include <Adafruit_GFX.h>    // Core graphics library
#include <Adafruit_ST7735.h> // Hardware-specific library
#include <I2Cdev.h>
#include <MPU6050.h>
#include <Adafruit_VL53L0X.h>

#ifdef WATCHDOG
  #include <avr/wdt.h>
#endif
  

// For the breakout, you can use any 2 or 3 pins
// These pins will also work for the 1.8" TFT shield
//MOSI 11, SCK 13
#define TFT_CS     10
#define TFT_RST    9  // you can also connect this to the Arduino reset
                      // in which case, set this #define pin to 0!
#define TFT_DC     8

#define H_TRIGGER 200 //mm
#define T 35 //
#define H 300 //mm
#define W 45 //°
#define G -0.2 //g

#define H_TRIGGER_OFFSET 20 //mm
#define H_TRIGGER_HYST  10 //mm
#define T_HYST 5 //
#define H_HYST 100 //mm
#define W_HYST 15 //°
#define G_HYST 0.2 //g

#define GRAD 167

#define LINKS  1
#define RECHTS 2
#define OBEN   3
#define UNTEN  4
#define MITTE  5
#define KEINE  0

#define U_KAL  0.0152
#define I_KAL  0.034
#define I_OFF  502
#define U_RES  0.04
#define I_RES  0.04

#define MITTEL 10
#define T_UI   1000
#define T_MESS 100

#define PIN_IFL  2
#define PIN_PRED 3
#define PIN_P0   6
#define PIN_P0HTRIGGER 7
#define PIN_TAAD A3
#define PIN_IAD  A2
#define PIN_UAD  A1
#define PIN_PAD  A0
#define PIN_REL  5

Adafruit_ST7735 tft = Adafruit_ST7735(TFT_CS,  TFT_DC, TFT_RST);
MPU6050 accelGyro(0x68);//Default 0x68
Adafruit_VL53L0X lox = Adafruit_VL53L0X();

//4-Wege-Schallter AD3
// Links: 335 - Rechts: 12 - Oben : 120 - Unten : 612 - Mitte :214 - frei : 674

//Frei 2,3,4,5,6,7,12,AD0,AD1,AD2

//-------------------------------------------------------------------------------
void setup(void) 
{


  pinMode( PIN_IFL,INPUT);
  pinMode(PIN_PRED,OUTPUT);
  digitalWrite(PIN_PRED,LOW);
  pinMode( 4,INPUT_PULLUP);
  pinMode(PIN_REL,OUTPUT);
  digitalWrite(PIN_REL,LOW);
  pinMode(PIN_P0,OUTPUT);
  digitalWrite(PIN_P0,HIGH);
  pinMode(PIN_P0HTRIGGER,OUTPUT);
  digitalWrite(PIN_P0HTRIGGER,HIGH);
  
  // Use this initializer if you're using a 1.8" TFT
  tft.initR(INITR_BLACKTAB);   // initialize a ST7735S chip, black tab
   tft.setRotation(1);
  // Use this initializer (uncomment) if you're using a 1.44" TFT
  //tft.initR(INITR_144GREENTAB);   // initialize a ST7735S chip, black tab
  tft.setTextWrap(true);
 tft.setTextSize(2);


 tft.fillScreen(ST7735_BLACK);

  tft.setTextColor(ST7735_YELLOW);
  tft.setCursor(3,2);
  tft.print(F("PLH3D-6W"));
  tft.setCursor(103,2);
  tft.print(F("*"));
  tft.drawFastHLine(101,8,45,ST7735_YELLOW);
  tft.drawFastHLine(101,9,45,ST7735_YELLOW);

  tft.setTextSize(1);
  tft.setTextColor(ST7735_WHITE);

  //tft.fillRect(0,0,160,128,ST7735_BLACK);
  

    //Serial.begin(115200);
    bool start_b=false;
    Wire.begin();
    accelGyro.initialize();
    tft.setCursor(2,14*2);
    tft.print(F("Suche Sensoren..."));
    tft.setCursor(2,14*3);
    tft.print(F("MPU6050"));
    if (accelGyro.testConnection()) 
    {
      tft.setTextColor(ST7735_GREEN);
      tft.print(F(" OK"));
      accelGyro.setFullScaleAccelRange(0x2);//8g
      start_b=true;
    }
    else
    {
      tft.setTextColor(ST7735_RED);
      tft.print(F(" FEHLER"));
      start_b=false;
    }
    tft.setCursor(2,14*4); 
    tft.setTextColor(ST7735_WHITE); 
    tft.print(F("VL530X"));  
    if(lox.begin())  
    {
      tft.setTextColor(ST7735_GREEN);
      tft.print(F(" OK"));
      start_b=true;
    }
    else 
    {
      tft.setTextColor(ST7735_RED);
      tft.print(F("FEHLER"));
      start_b=false;
    }
    tft.setTextColor(ST7735_WHITE);
    tft.setCursor(2,14*5);    
    if(!start_b)
    {
      tft.setTextColor(ST7735_RED);
      tft.print(F("Gestoppt"));
      while(1);
    }

    delay(1000);
    tft.fillRect(0,20,160,108,ST7735_BLACK);
//    tft.setCursor(0,14);
//    for(int i=0;i<117;i++)
//    {
//      tft.print(i);
//      tft.write(i);
//      delay(1000);
//    }   
//    tft.fillRect(0,20,160,108,ST7735_BLACK);
//    tft.setCursor(0,14);
//    for(int i=118;i<208;i++)
//    {
//      tft.print(i);
//      tft.write(i);
//      delay(1000);
//    }   
//    tft.fillRect(0,20,160,108,ST7735_BLACK);
//    tft.setCursor(0,14);
//    for(int i=209;i<255;i++)
//    {
//      tft.print(i);
//      tft.write(i);
//      delay(1000);
//    }       
    //tft.invertDisplay(true);
#ifdef WATCHDOG
  wdt_enable(WDTO_500MS);
  wdt_reset();
#endif    
}
//-------------------------------------------------------------------------------
void loop() 
{
#ifdef WATCHDOG
  wdt_reset();
#endif  
static int taste_ad,w=0, hm[MITTEL];
static byte taste,taste_alt,menu=0,menu_alt=0;
static bool taste_b=false, lage_flag_b=false,temp_flag_b=false,h_flag_b=false,i_flag_b=false;
static unsigned long ui_zeit=millis(),sensor_zeit=millis();
static float gx, gy, gy_trig, gz, u, i, im[MITTEL], gym[MITTEL], t, h, h_trigger=H_TRIGGER, p;
static byte wm[MITTEL],gy_index=0, h_index=0,w_index=0,i_index=0;
static float gx_alt, gy_alt, gz_alt, u_alt, i_alt, t_alt, h_alt, h_trigger_alt=H_TRIGGER, p_alt,w_alt;

//++++++++++++++++++Eingangsdaten++++++++++++++++++++  
if(millis()-sensor_zeit>T_MESS)
{
  sensor_zeit=millis();
  gx=accelGyro.getAccelerationX();
  gy=accelGyro.getAccelerationY();
  gz=accelGyro.getAccelerationZ();


  gym[gy_index++]=gy;
  gy_trig=0;
  for(byte idx=0;idx<MITTEL;idx++)
  {
    gy_trig+=gym[idx];
  }
  gy_trig/=MITTEL;
  
  wm[w_index++]=abs(180*atan(sqrt(gy*gy)/sqrt(gx*gx+gz*gz))/3.1415);
  if(w_index>MITTEL-1)w_index=0;
  w=0;
  for(byte idx=0;idx<MITTEL;idx++)
  {
    w+=wm[idx];
  }
  w/=MITTEL;
  t =accelGyro.getTemperature();
  p=101.7*((float)analogRead(PIN_PAD)/1024.0);
  if(p>100.0) p=100.0;
  u=U_KAL*(float)analogRead(PIN_UAD);
  im[i_index++]=I_KAL*(float)(analogRead(PIN_IAD)-I_OFF);
  if(i_index>MITTEL-1)i_index=0;
  i=0;
  for(byte idx=0;idx<MITTEL;idx++)
  {
    i+=im[idx];
  }
  i/=MITTEL;

  if(i<0.0)i=0.0;
  VL53L0X_RangingMeasurementData_t measure;
  lox.rangingTest(&measure, false); // pass in 'true' to get debug data printout!
  if (measure.RangeStatus != 4)
  {
      hm[h_index++]=(int)measure.RangeMilliMeter;
      if(h_index>MITTEL-1)h_index=0;
      h=0;
      for(byte idx=0;idx<MITTEL;idx++)
      {
        h+=(float)hm[idx];
      }
      h/=MITTEL;  
  }      
  else
        h=9999.9;
}        

        
  taste_alt=taste;
  taste_ad=analogRead(PIN_TAAD);
 
  if     (taste_ad > 315 && taste_ad < 365) taste = LINKS;
  else if(taste_ad >   0 && taste_ad <  42) taste = RECHTS;
  else if(taste_ad > 110 && taste_ad < 130) taste = OBEN;
  else if(taste_ad > 590 && taste_ad < 642) taste = UNTEN;
  else if(taste_ad > 190 && taste_ad < 264) taste = MITTE;
  else if(taste_ad > 664 )  taste = KEINE;
  else                     taste = KEINE;
//++++++++++++++++++Eingangsdaten Ende+++++++++++++++  

//++++++++++++++++++Sicherheits-Flags++++++++++++++++
if(w<W || gy_trig > G) lage_flag_b=false;
else if((w>W+W_HYST) && (gy_trig < G-G_HYST))lage_flag_b=true; 
if(t>T) temp_flag_b=false;
else if(t<T-T_HYST) temp_flag_b=true; 
if(h>H) h_flag_b=false;
else if(h<H-H_HYST)h_flag_b=true;
 i_flag_b=digitalRead(PIN_IFL);

if(lage_flag_b 
   && temp_flag_b 
   && h_flag_b 
   //&& i_flag_b
   ) digitalWrite(PIN_REL,HIGH);
else digitalWrite(PIN_REL,LOW);

if(h > h_trigger+H_TRIGGER_OFFSET) digitalWrite(PIN_P0HTRIGGER,HIGH);
else if(h < h_trigger+H_TRIGGER_OFFSET-H_TRIGGER_HYST) digitalWrite(PIN_P0HTRIGGER,LOW);

//++++++++++++++++++Sicherheits-Flags Ende+++++++++++

//++++++++++++++++Tasten+++++++++++++++++++++++++++++
  switch(taste)
  {
    case RECHTS: 
    if(!taste_b)
    {
      menu++;
      if(menu>2)menu=0;
      taste_b=true;
    }
    break;
    case LINKS: 
    if(!taste_b)
    {
      if(menu>0)menu--;
      else menu=2;
      taste_b=true;
    }
    break;
    case OBEN: 
      if(menu==0 && !digitalRead(PIN_P0))digitalWrite(PIN_PRED,LOW);
    break;
    case UNTEN: 
      if(menu==0 && !digitalRead(PIN_P0))digitalWrite(PIN_PRED,HIGH);
    break;
    case MITTE:
    if(!taste_b && digitalRead(PIN_P0)==LOW && !digitalRead(PIN_PRED))
    {
      digitalWrite(PIN_P0,HIGH);
      taste_b=true;  
    }
    else if(!taste_b && !digitalRead(PIN_PRED))
    {
      digitalWrite(PIN_P0,LOW);
      taste_b=true;
    }
    else if(digitalRead(PIN_PRED))
    {
     if(h<=200)  h_trigger=h;
    }
    break;
    case KEINE: 
      taste_b=false;
    break;
  }
//++++++++++++++++Tasten Ende++++++++++++++++++++++++




//++++++++++++++++++Ausgabe++++++++++++++++++++++++++

  { 
    tft.setTextColor(ST7735_WHITE);
    tft.setCursor(152,5);
    tft.setTextSize(1);
    tft.print(menu+1);
    tft.setCursor(2,20);
    if(menu==0) 
    {
        static bool wechsel_b[3]={true,true,true};
        if(menu_alt!=menu) 
        {
          tft.fillRect(150,5,10,7,ST7735_BLACK);
          tft.fillRect(0,20,160,108,ST7735_BLACK);
          if(!digitalRead(PIN_P0) && !digitalRead(PIN_PRED))
            tft.fillRect(0,48,160,32,ST7735_WHITE);
          menu_alt=menu;
        }
        
        tft.setTextSize(2);
        tft.print(F("Leistung: "));     
        tft.setCursor(10,50);
        if(digitalRead(PIN_P0))
        {
          if(wechsel_b[0])tft.fillRect(0,48,160,32,ST7735_BLACK);
          wechsel_b[0]=false;
          wechsel_b[1]=true;
          wechsel_b[2]=true;
          tft.print(F("Pause"));
          if(p_alt!=p)
          {
            tft.fillRect(75,50,85,14,ST7735_BLACK);
            p_alt=p;
          }
          tft.setCursor(75,50);
          tft.print(p,1);
          tft.print(F("%"));
        }
        else if(digitalRead(PIN_PRED))
        {
          if(wechsel_b[1])tft.fillRect(0,48,160,80,ST7735_BLACK);
          wechsel_b[0]=true;
          wechsel_b[1]=false;
          wechsel_b[2]=true;
          if(p_alt!=p)
          {
            tft.fillRect(70,50,90,14,ST7735_BLACK);
            p_alt=p;
          }          
          tft.setCursor(10,50);
          tft.print(F("red.("));
          tft.print(p,1);
          tft.print(F("%)"));


          if(h_alt!=h)
          {
            tft.fillRect(0,70,160,14,ST7735_BLACK);        
            h_alt=h;            
          }
          tft.setCursor(10,70);
          if(h<300) tft.print(h,0);
          else tft.print(F("?"));
          tft.print(F("mm"));     
          if(h_trigger<=H_TRIGGER)
          {     
            if(h > h_trigger+H_TRIGGER_OFFSET) tft.setTextColor(Color565(255,128,128));
            else tft.setTextColor(ST7735_WHITE);  
            
            if(h_trigger_alt!=h_trigger)
            {
              tft.fillRect(0,90,160,14,ST7735_BLACK);        
              h_trigger_alt=h_trigger;            
            }  
            tft.setCursor(10,90);
            tft.print(h_trigger,0);
            tft.print(F("mm(trig.)"));          
          }  
        }        
        else
        {
          if(wechsel_b[2])
          {
            tft.fillRect(0,50,160,78,ST7735_BLACK);
            tft.fillRect(0,48,160,32,ST7735_WHITE);            
          }
          wechsel_b[0]=true;
          wechsel_b[1]=true;
          wechsel_b[2]=false;
          tft.setTextSize(4);
          if(p_alt!=p)
          {
            tft.fillRect(0,48,160,32,ST7735_WHITE);
            p_alt=p;
          }
          tft.setTextColor(ST7735_BLACK);
          tft.print(p,1);
          tft.print(F("%"));
           tft.setTextColor(ST7735_WHITE);
          tft.setCursor(10,85);
          tft.setTextSize(2);
          if(digitalRead(PIN_P0HTRIGGER))
            tft.setTextColor(Color565(255,128,128));
          else
            tft.setTextColor(ST7735_BLACK);
          tft.print(F("CNC Pause"));
        }
        tft.setTextSize(2);
        tft.setTextColor(ST7735_WHITE);

//        tft.fillRect(0,95,160,14,ST7735_BLACK);
//        tft.setCursor(10,95);
//        tft.print(u_alt-u,2);
//        tft.print(F("V "));
//        tft.print(i_alt-i,2);
//        tft.print(F("A"));
        if(millis()-ui_zeit>T_UI)
        {
          ui_zeit=millis();
          //if((u_alt-u>=U_RES || u_alt-u<=-U_RES ) || (i_alt-i>=I_RES || i_alt-i<=-I_RES))
          if((u_alt!=u) || (i_alt!=i))
          {   
            tft.fillRect(0,110,160,14,ST7735_BLACK);        
            u_alt=u;
            i_alt=i;
          }        
          tft.setCursor(10,110);
          tft.print(u,1);
          tft.print(F("V "));
          tft.print(i,1);
          tft.print(F("A"));
        }
    }
    else if(menu==1)
    {
      if(menu_alt!=menu) 
      {
        tft.fillRect(150,5,10,7,ST7735_BLACK);
        tft.fillRect(0,20,160,108,ST7735_BLACK);
        menu_alt=menu;
      }
      tft.print(F("Messwerte"));
      tft.setTextSize(2);
      //if((u_alt-u>=U_RES || u_alt-u<=-U_RES ) || (i_alt-i>=I_RES || i_alt-i<=-I_RES))
      if((u_alt!=u) || (i_alt!=i))
      {
        tft.fillRect(0,30,160,14,ST7735_BLACK);        
        u_alt=u;
        i_alt=i;
      }         
      tft.setCursor(10,30);
      tft.print(u,1);
      tft.print(F("V "));
      tft.print(i,1);
      tft.print(F("A"));

      if(p_alt!=p)
      {
        tft.fillRect(0,50,160,14,ST7735_BLACK);                 
        p_alt=p;
      }      
      tft.setCursor(10,50);
      tft.print(p*6.0/100.0,1);
      tft.print(F("W "));
      tft.print(p,1);
      tft.print(F("%")); 

      if((h_alt!=h) || (t_alt!=t))
      {
        tft.fillRect(0,70,160,14,ST7735_BLACK);                
        h_alt=h;
        t_alt=t;
      }               
      tft.setCursor(10,70);
      if(h<1200) tft.print(h,0);
      else tft.print(F("?"));
      tft.print(F("mm "));
      tft.print(t,0);
      tft.write(GRAD);
      tft.print(F("C"));
      if(w_alt!=w)
      {
        tft.fillRect(0,90,160,14,ST7735_BLACK);        
         w_alt=w;
      }         
      tft.setCursor(10,90);
      tft.print(w,1);
      tft.write(GRAD);   

      
      tft.setTextSize(1);
      tft.setCursor(10,107);
      tft.print(F("T-L-H-I"));

      tft.fillRect(0,117,160,11,ST7735_BLACK);
      tft.setCursor(10,117);
      tft.print(temp_flag_b);
      tft.print(F("-"));
      tft.print(lage_flag_b);
      tft.print(F("-"));
      tft.print(h_flag_b);
      tft.print(F("-"));
      tft.print(i_flag_b);
    }
    else if(menu==2) 
    {
      if(menu_alt!=menu) 
      {
        tft.fillRect(150,5,10,7,ST7735_BLACK);
        tft.fillRect(0,20,160,108,ST7735_BLACK);
        menu_alt=menu;
      }
      tft.setTextSize(2);
      tft.setCursor(10,30);      
      tft.print(F("M.Sc.T.Pfaff"));
      tft.setCursor(10,50);      
      tft.print(F("V1.1 - 2018"));
      tft.setTextSize(1);
      tft.setCursor(10,75);      
      tft.print(F("Pinbelegung"));
      tft.setCursor(10,85);      
      tft.print(F("1: I2C  5: ANG   9: 12V+"));
      tft.setCursor(10,95);      
      tft.print(F("2: I2C  6: AGND 10: 12V+"));
      tft.setCursor(10,105);      
      tft.print(F("3: NC   7: GND"));      
      tft.setCursor(10,115);      
      tft.print(F("4: 5V+  8: GND (12V= 3A)"));

//      tft.print("RAW");
//
// 
//      for(byte i=2;i<=7;i++)
//      {
//        tft.setCursor(2,10*i+10);
//        tft.print(i);
//        tft.print(" : ");
//        tft.print(digitalRead(i));
//      }
//      tft.setCursor(2,10*8+10);
//      tft.print("12: ");
//      tft.print(digitalRead(12));
//      
//      tft.setCursor(40,30);
//      tft.print("P: ");
//      tft.print(p);
//      tft.print("% ");
//      tft.print(p*6.0/100.0);
//      tft.print("W");      
//      tft.setCursor(40,40);
//      tft.print("U: ");
//      tft.print(u);
//      tft.print("V");
//      tft.setCursor(40,50);
//      tft.print("I: ");
//      tft.print(i);
//      tft.print("A ");
//      tft.print(i_flag_b);
//      tft.setCursor(40,60);
//      tft.print("Lage:");
//      tft.print(lage_flag_b);
//      tft.print(";");
//      tft.print(abs(gx));
//      tft.print(";");
//      tft.print(abs(gy));
//      tft.print(";");
//      tft.print(abs(gz));
//      tft.setCursor(40,70);
//      tft.print("T: ");
//      tft.print(temp_flag_b);
//      tft.print("-");
//      tft.print(t);
//      tft.print("*");
//      tft.setCursor(40,80);
//      tft.print("h: ");
//      tft.print(h_flag_b);
//      tft.print("-");
//      tft.print(h);
//      tft.print("mm");
//      tft.setCursor(40,90);
//      tft.print("Taste: ");
//      switch(taste)
//      {
//        case LINKS:  tft.print("LINKS" ); 
//        break;
//        case RECHTS: tft.print("RECHTS"); 
//        break;
//        case OBEN:   tft.print("OBEN"  ); 
//        break;
//        case UNTEN:  tft.print("UNTEN" );  
//        break;
//        case MITTE:  tft.print("MITTE" ); 
//        break;
//        case KEINE:  tft.print("KEINE" ); 
//        break;
//      }
//      tft.print("-");
//      tft.print(taste_ad);
    ;}

  
    //if(gi==0)
      delay(10);
  }  
//++++++++++++++++++Ausgabe Ende++++++++++++++++++++++
  
}
//-------------------------------------------------------------------------------
//-----------------------------------------------------------------------
uint16_t Color565(uint8_t r, uint8_t g, uint8_t b) 
{
  return ((r & 0xF8) << 8) | ((g & 0xFC) << 3) | (b >> 3);
}

