/*
   Einheit 1=V, 2=A, 3=m/s Steigen, 4=km/h, 5=1/min, 6=*C,
            7=*, 8=m, 9=%Sprit, 10=%Signal, 11=mAh, 12=ml, 13=km, 14=tbd, 15=tbd


Achtung: Für Ni Überwachung:
4 Zellen: nur Pin1 belegen (Pin0, Pin3, Pin4, Pin5 frei)            
5 Zellen: nur Pin2 belegen (Pin0, Pin1, Pin4, Pin5 frei)

Mit der Verwendung dieser Firmware erkennt der Nutzer an, dass die
Nutzung des Programms ebenso wie alle ermittelten Werte und Messungen auf seine eigene
Verantwortung erfolgt. Von Seiten des Autors wird keine Haftung, Garantie und/oder Gewährleis-
tung für die Richtigkeit der ermittelten Werte und Angaben, sowie für Schäden und Folgeschäden
oder Kosten ideller und/oder materieller Art, seien sie indirekt oder direkt durch oder in Zusammen-
hang mit dieser Software entstanden übernommen.
Diese Firmware darf beliebig weiter gegeben, in keinem Fall jedoch gegen
Gebühr oder Kosten veräussert werden. Eine Nutzung zum Zwecke der Gewinnerzielung erfordert
die ausdrückliche Zustimmung des Autors. Die Nutzung für wissenschaftliche und Ausbildungs-
zwecke bedarf keiner gesonderten Erlaubnis oder Verabredung.
*/
//+++++++++++++++++Konfiguration++++++++++++++++++++++
#define _U3V
//#define _U5V
#define UMIN    100   //mV Mindestspannung unter der nicht gesendet wird
#define MITTEL 7     //Anzahl der Messungen für eine Mittelwertbildung
#define MESSZEIIT 1000 //Zeit zwischen zwei Messungen in ms

#ifdef _U3V
#define KAL0   4.421
#define KAL1   8.984
#define KAL2  13.003
#define KAL3  17.891
#define KAL4  21.148
#define KAL5  24.730
#define KAL6  30.092
#define KAL7  35.480
#endif

#ifdef _U5V
#define KAL0   4.960
#define KAL1   9.919
#define KAL2  13.812
#define KAL3  17.647
#define KAL4  23.088
#define KAL5  27.370
#define KAL6  32.026
#define KAL7  37.458
#endif

//+++++++++++++++++Konfiguration Ende+++++++++++++++++

#define CSB_HIGH  0x76   //CBR=1 0x76 I2C address when CSB is connected to HIGH (VCC)
#define CSB_LOW   0x77   //CBR=0 0x77 I2C address when CSB is connected to LOW (GND)

#define FLAG_PIN0 2
#define FLAG_PIN1 3
#define FLAG_PIN2 4

#define LED_PIN0  5
#define LED_PIN1  6
#define LED_PIN2  7
#define LED_PIN3  8
#define LED_PIN4  9
#define TON_PIN  10

//#define MS561101BA_D1 0x40
//#define MS561101BA_D2 0x50
// OSR (Over Sampling Ratio) constants
//#define OSR_256 0x00
//#define OSR_512 0x02
//#define OSR_1024 0x04
//#define OSR_2048 0x06
//#define OSR_4096 0x08

//#define TIME    0
//#define TEMP 	1
//#define PRESS 	2
//#define HIGHT 	3
//#define VELO	4
//#define ERROR -3.4028235E+38


//#define CS 6

#define LED_PIN 13
#define ML_KD     0
#define ML_V      1
#define ML_A      2
#define ML_MpS    3
#define ML_KMpH   4
#define ML_UpMIN  5
#define ML_GRADC  6
#define ML_GRAD   7
#define ML_M      8
#define ML_VHKAP  9
#define ML_VHSIG 10
#define ML_MAH   11
#define ML_ML    12
#define ML_KM    13
#define ML_HPA   14 
#define ML_TBD15 15
#define ML_GET_TIMEOUT 5 //in ms
#define ML_LCD_GRAD 0xDF
#define MAXKANAL 16
#define SETW 1
#define GETW 2
#define SETE 3
#define GETE 4
#define SET  5
#define GET  6
#define LANG 100



#include <Wire.h>
//#include <SoftwareSerial.h>
//SoftwareSerial mySerial(8, 9); // RX, TX
#include <TimerOne.h>

float temp = 0, hoch = 0, druck =0, v_steig =0;
bool flag0 = false, flag1 = false, flag2 = false, flag3 = false;
float v;
uint16_t sample;
uint16_t C[7];
uint8_t CSB_address;	
bool init_b;
bool velo_b;
bool senden_b;

		int AC1,AC2,AC3,VB1,VB2,MB,MC,MD;
		unsigned int AC4,AC5,AC6; 
		double c5,c6,mc,md,x0,x1,x2,y0,y1,y2,p0,p1,p2;
		char _error;

  unsigned short a0=0;
  unsigned short a1=0;
  unsigned short a2=0;
  unsigned short a3=0;
  unsigned short a4=0;
  unsigned short a5=0;
  unsigned short a6=0;
  unsigned short a7=0;

#define BMP180_ADDR 0x77 // 7-bit address

#define	BMP180_REG_CONTROL 0xF4
#define	BMP180_REG_RESULT 0xF6

#define	BMP180_COMMAND_TEMPERATURE 0x2E
#define	BMP180_COMMAND_PRESSURE0 0x34
#define	BMP180_COMMAND_PRESSURE1 0x74
#define	BMP180_COMMAND_PRESSURE2 0xB4
#define	BMP180_COMMAND_PRESSURE3 0xF4



void callback(unsigned char index_i)
{
    //hier können Messwerte ermittelt und an den Treiber übergeben werden.
    //Jeder Abschnitt (durch index_i durchnummeriert) muss in 2ms-3ms abgearbeitet sein.
    //mLink.werte(<Messwert>,<Einheit>,<Indexübergabe aus Callback-Funktsionsargument>);


  unsigned short aus=0xFFFF;
  static byte index_off=0;
  
 

    a0=KAL0*analogRead(A0);
    a1=KAL1*analogRead(A1);
    a2=KAL2*analogRead(A2);
    a3=KAL3*analogRead(A3);
    a4=KAL4*analogRead(A6);
    a5=KAL5*analogRead(A7);
    if(!flag3)
    {
      a6=KAL5*analogRead(A4);
      a7=KAL5*analogRead(A5);
    }
    byte zellen=0;
    unsigned short ages=10000;
    if(a0>UMIN) zellen++;
    if(a1>UMIN) zellen++;
    if(a2>UMIN) zellen++;
    if(a3>UMIN) zellen++;
    if(a4>UMIN) zellen++;
    if(a5>UMIN) zellen++;
    if(!flag3)
    {
      if(a6>UMIN) zellen++;
      if(a7>UMIN) zellen++;
    }

    if(zellen > 1) //meht als ein Spannungspin verwendet => muss Li-Zelen sein
    {
      if(!flag3)
      {
        if(a7 > 20) a7 -= a6;
        else a7=0;  
        if(a6 > 20) a6 -= a5;
        else a6=0;
      }    
      if(a5 > 20) a5 -= a4;
      else a5=0;  
      if(a4 > 20) a4 -= a3;
      else a4=0;  
      if(a3 > 20) a3 -= a2;
      else a3=0;
      if(a2 > 20) a2 -= a1;
      else a2=0;  
      if(a1 > 20) a1 -= a0; 
      else a1=0;  
      if(a0 <= 20)a0  =  0;
    }
  


  //  flag0                 1                  2                                                    3
  //  0=3,3V/1=2,8V     0=Umess aus/1=ein  0=nur U schwächste Zelle/ 1= U aller Zellen + Uges   0=kein BMPP180 /1=BMP180 vorhanden

  switch(index_i)
  {
    case 2:
          if(flag3) werte(hoch,ML_M,index_i);
    break;
    case 3:
          if(flag3) werte(v_steig,ML_MpS,index_i);   
    break;
  }
  if(!flag3)index_off = 2;
  else index_off = 0;
  switch(index_i+index_off)
  {           
    case 4:
        if(flag1)
        {
              if(!flag2)
              {
                if(a0 > 20 || a1 > 20 || a2 > 20 || a3 > 20 || a4 > 20 || a5 > 20)
                {
                 if(a0 > 20 && aus > (a0+ 2)) aus =  a0-2;
                 if(a1 > 20 && aus > (a1+ 3)) aus =  a1-3;
                 if(a2 > 20 && aus > (a2+ 5)) aus =  a2-5;
                 if(a3 > 20 && aus > (a3+ 6)) aus =  a3-6;
                 if(a4 > 20 && aus > (a4+ 8)) aus =  a4-8;
                 if(a5 > 20 && aus > (a5+10)) aus = a5-10;
                 if(!flag3 && (a6 > 20 || a7 > 20 ))
                 {
                   if(a6 > 20 && aus > (a6+12)) aus = a6-12;
                   if(a7 > 20 && aus > (a7+14)) aus = a7-14;                 
                 }
                }   
              }
              else
              {
                 if(!flag3)
                    aus=a0+a1+a2+a3+a4+a5+a6+a7;
                 else
                    aus=a0+a1+a2+a3+a4+a5;              
              }
           
              if(aus < 0xFFFF)
              {
                werte(((float)aus/1000.0),ML_V,index_i);
              }   
        }
    break;
    case 5:
          if(flag1 && flag2 && a0>UMIN)
            werte((((float)a0)/1000.0),ML_V,index_i);  
    break;
    case 6:
          if(flag1 && flag2 && a0>UMIN && a1>UMIN) 
            werte(((float)a1/1000.0),ML_V,index_i);   
    break;
    case 7:
          if(flag1 && flag2 && a0>UMIN && a1>UMIN && a2>UMIN) 
            werte(((float)a2/1000.0),ML_V,index_i); 
    break;
    case 8:
          if(flag1 && flag2 && a0>UMIN && a1>UMIN && a2>UMIN && a3>UMIN) 
            werte(((float)a3/1000.0),ML_V,index_i);  
    break;
    case 9:
          if(flag1 && flag2 && a0>UMIN && a1>UMIN && a2>UMIN && a3>UMIN && a4>UMIN) 
            werte(((float)a4/1000.0),ML_V,index_i);
    break;
    case 10:
          if(flag1 && flag2 && a0>UMIN && a1>UMIN && a2>UMIN && a3>UMIN && a4>UMIN && a5>UMIN)
            werte(((float)a5/1000.0),ML_V,index_i);  
    break;   
    case 11:
          if(flag2 && flag3)werte(temp,ML_GRADC,index_i);
          else if(!flag3)
          {
             if(flag1 && flag2 && a0>UMIN && a1>UMIN && a2>UMIN && a3>UMIN && a4>UMIN && a5>UMIN && a6>UMIN)
                werte(((float)a6/1000.0),ML_V,index_i);        
          }
    break;  
    case 12:
          if(!flag3)
          {
             if(flag1 && flag2 && a0>UMIN && a1>UMIN && a2>UMIN && a3>UMIN && a4>UMIN && a5>UMIN && a6>UMIN && a7>UMIN)
                werte(((float)a7/1000.0),ML_V,index_i);        
          }
    break;  
          
  }//*/

}
//---------------------------------------------------------------------------------------
void setup() 
{
  //Serial.begin(9600);
  Serial.begin(38400); 
  Serial.setTimeout(2);

//  pinMode(CS,OUTPUT);
//  digitalWrite(CS,LOW);
  pinMode(LED_PIN,OUTPUT);
  pinMode(FLAG_PIN0,INPUT);
  pinMode(FLAG_PIN1,INPUT);
  pinMode(FLAG_PIN2,INPUT);

  pinMode(LED_PIN0,OUTPUT);
  pinMode(LED_PIN1,OUTPUT);
  pinMode(LED_PIN2,OUTPUT);
  pinMode(LED_PIN3,OUTPUT);
  pinMode(LED_PIN4,OUTPUT);
  pinMode(TON_PIN,OUTPUT);

  //  flag0                 1                  2                                                    3
  //  0=3,3V/1=2,8V     0=Umess aus/1=ein  0=nur U schwächste Zelle/ 1= U aller Zellen + Uges   0=kein BMPP180 /1=BMP180 vorhanden
  flag0 = digitalRead(FLAG_PIN0);
  flag1 = digitalRead(FLAG_PIN1);
  flag2 = digitalRead(FLAG_PIN2);
  flag3 = init(MESSZEIIT); //CSB_HIGH -> 0x76/ CSB_LOW -> 0x77, Samplingrate für Steiggeschwindigkekeit in ms (200...10000)
  Serial.print(flag0);Serial.print(" - ");
  Serial.print(flag1);Serial.print(" - ");
  Serial.print(flag2);Serial.print(" - ");
  Serial.println(flag3);
  digitalWrite(LED_PIN,LOW);
  //UNO: SCL ->  A5, SDA -> A4  CS beliebig
//  Timer1.initialize(1000); // set a timer of length 100000 microseconds (or 0.1 sec - or 10Hz => the led will blink 5 times, 5 cycles of on-and-off, per second)
//  Timer1.attachInterrupt( daten2 ); // attach the service routine here

}
//---------------------------------------------------------------------------------------
bool init(uint16_t spl) 
{  
	spl /= MITTEL;
	if(spl < 200) sample = 200;
	else if(spl > 100000) sample = 100000; 
	else sample = spl;


// Disable internal pullups, 10Kohms are on the breakout
	PORTC |= (1 << 4);
	PORTC |= (1 << 5);

	double c3,c4,b1;
	
	// Start up the Arduino's "wire" (I2C) library:
	
	Wire.begin();
        delay(100);
	
	if (readInt(0xAA,AC1) &&
		readInt(0xAC,AC2) &&
		readInt(0xAE,AC3) &&
		readUInt(0xB0,AC4) &&
		readUInt(0xB2,AC5) &&
		readUInt(0xB4,AC6) &&
		readInt(0xB6,VB1) &&
		readInt(0xB8,VB2) &&
		readInt(0xBA,MB) &&
		readInt(0xBC,MC) &&
		readInt(0xBE,MD))
	{



		c3 = 160.0 * pow(2,-15) * AC3;
		c4 = pow(10,-3) * pow(2,-15) * AC4;
		b1 = pow(160,2) * pow(2,-30) * VB1;
		c5 = (pow(2,-15) / 160) * AC5;
		c6 = AC6;
		mc = (pow(2,11) / pow(160,2)) * MC;
		md = MD / 160.0;
		x0 = AC1;
		x1 = 160.0 * pow(2,-13) * AC2;
		x2 = pow(160,2) * pow(2,-25) * VB2;
		y0 = c4 * pow(2,15);
		y1 = c4 * c3;
		y2 = c4 * b1;
		p0 = (3791.0 - 8.0) / 1600.0;
		p1 = 1.0 - 7357.0 * pow(2,-20);
		p2 = 3038.0 * 100.0 * pow(2,-36);		
		// Success!
		return(1);
	}
	else
		return(0);
}
//-----------------------------------------------------------------------------------------------------
void check() 
{
  static long int zeit_i=micros();
  if(micros()-zeit_i >= 1000)
  {
    //Serial.println(micros()-zeit_i);
    zeit_i=micros();
    daten2();
  } 
}  
//-----------------------------------------------------------------------------------------------------
char readInt(char address, int &value)
// Read a signed integer (two bytes) from device
// address: register to start reading (plus subsequent register)
// value: external variable to store data (function modifies value)
{
	unsigned char data[2];

	data[0] = address;
	if (readBytes(data,2))
	{
		value = (((int)data[0]<<8)|(int)data[1]);
		//if (*value & 0x8000) *value |= 0xFFFF0000; // sign extend if negative
		return(1);
	}
	value = 0;
	return(0);
}
//------------------------------------------------------------------  
char readUInt(char address, unsigned int &value)
// Read an unsigned integer (two bytes) from device
// address: register to start reading (plus subsequent register)
// value: external variable to store data (function modifies value)
{
	unsigned char data[2];

	data[0] = address;
	if (readBytes(data,2))
	{
		value = (((unsigned int)data[0]<<8)|(unsigned int)data[1]);
		return(1);
	}
	value = 0;
	return(0);
}
//------------------------------------------------------------------  
char readBytes(unsigned char *values, char length)
// Read an array of bytes from device
// values: external array to hold data. Put starting register in values[0].
// length: number of bytes to read
{
	char x;

	Wire.beginTransmission(BMP180_ADDR);
check();
	Wire.write(values[0]);
check();
	_error = Wire.endTransmission();
check();
	if (_error == 0)
	{
		Wire.requestFrom(BMP180_ADDR,length);
check();
		while(Wire.available() != length) check(); // wait until bytes are ready
		for(x=0;x<length;x++)
		{
check();
			values[x] = Wire.read();
check();
		}
		return(1);
	}
	return(0);
}
//------------------------------------------------------------------  
char writeBytes(unsigned char *values, char length)
// Write an array of bytes to device
// values: external array of data to write. Put starting register in values[0].
// length: number of bytes to write
{
	char x;
	
	Wire.beginTransmission(BMP180_ADDR);
check();
	Wire.write(values,length);
check();
	_error = Wire.endTransmission();
check();
	if (_error == 0)
		return(1);
	else
		return(0);
}
//------------------------------------------------------------------  
char startTemperature(void)
{
	unsigned char data[2], result;
	
	data[0] = BMP180_REG_CONTROL;
	data[1] = BMP180_COMMAND_TEMPERATURE;
check();
	result = writeBytes(data, 2);
check();
	if (result) // good write?
		return(5); // return the delay in ms (rounded up) to wait before retrieving data
	else
		return(0); // or return 0 if there was a problem communicating with the BMP
}
//------------------------------------------------------------------  
char getTemperature(double &T)
{
	unsigned char data[2];
	char result;
	double tu, a;
	
	data[0] = BMP180_REG_RESULT;
check();

	result = readBytes(data, 2);
check();
	if (result) // good read, calculate temperature
	{
check();
		tu = (data[0] * 256.0) + data[1];
	
		a = c5 * (tu - c6);
		T = a + (mc / (a + md));
	}
check();
	return(result);
}
//------------------------------------------------------------------  
char startPressure(char oversampling)
{
	unsigned char data[2], result, delay;
	
	data[0] = BMP180_REG_CONTROL;

	switch (oversampling)
	{
		case 0:
			data[1] = BMP180_COMMAND_PRESSURE0;
			delay = 5;
		break;
		case 1:
			data[1] = BMP180_COMMAND_PRESSURE1;
			delay = 8;
		break;
		case 2:
			data[1] = BMP180_COMMAND_PRESSURE2;
			delay = 14;
		break;
		case 3:
			data[1] = BMP180_COMMAND_PRESSURE3;
			delay = 26;
		break;
		default:
			data[1] = BMP180_COMMAND_PRESSURE0;
			delay = 5;
		break;
	}
check();
	result = writeBytes(data, 2);
check();
	if (result) // good write?
		return(delay); // return the delay in ms (rounded up) to wait before retrieving data
	else
		return(0); // or return 0 if there was a problem communicating with the BMP
}
//------------------------------------------------------------------  
char getPressure(double &P, double &T)
{
	unsigned char data[3];
	char result;
	double pu,s,x,y,z;
	
	data[0] = BMP180_REG_RESULT;
check();

	result = readBytes(data, 3);
check();
	if (result) // good read, calculate pressure
	{
		pu = (data[0] * 256.0) + data[1] + (data[2]/256.0);

		s = T - 25.0;
		x = (x2 * pow(s,2)) + (x1 * s) + x0;
		y = (y2 * pow(s,2)) + (y1 * s) + y0;
		z = (pu - x) / y;
		P = (p2 * pow(z,2)) + (p1 * z) + p0;

	}
	return(result);
}
//------------------------------------------------------------------  
void loop() 
{
  a0=KAL0*analogRead(A0);
  a1=KAL1*analogRead(A1);
  check();
  a2=KAL2*analogRead(A2);
  a3=KAL3*analogRead(A3);
  check();
  a4=KAL4*analogRead(A6);
  a5=KAL5*analogRead(A7);
  check();  
  if(!flag3)
  {
    a6=KAL4*analogRead(A4);
    a7=KAL5*analogRead(A5);
    check();
  }


//  Serial.print(a0);Serial.print(" - ");
//  Serial.print(a1);Serial.print(" - ");
//  Serial.print(a2);Serial.print(" - ");
//  Serial.print(a3);Serial.print(" - ");
//  Serial.print(a4);Serial.print(" - ");
//  Serial.println(a5);
  //flag  0                 1                  2
  //  0=LiPo /1=LiFe     0=Umess aus/1=ein  0=nur U schwächste Zelle/ 1= U aller Zellen + Uges    
  //LiPo Umax = 4,2 Umin=3,3  /LiFe Umax = 3,6 Umni = 2,8  

  if(a0 > 20 || a1 > 20 || a2 > 20 || a3 > 20 || a4 > 20 || a5 > 20)
  {
     unsigned short ni_zelle=0;
    if(a0 > 2000 && a1 <= 20 && a2 <= 20 && a3 <= 20 && a4 <= 20 && a5 <= 20)// 3 Zellen Ni an Pin1
    {
        ni_zelle = a0/3;
        check();
    }
    else if(a0 <= 20 && a1 > 2000 && a2 <= 20 && a3 <= 20 && a4 <= 20 && a5 <= 20)// 4 Zellen Ni an Pin1
    {
        ni_zelle = a1/4;
        check();
    }
    else if(a0 <= 20 && a1 <= 20 && a2 > 2000 && a3 <= 20 && a4 <= 20 && a5 <= 20)// 5 Zellen Ni an Pin2
    {
        ni_zelle = a2/5;
        check();
    }        
    else if(a0 <= 20 && a1 <= 20 && a2 <= 20 && a3 > 2000 && a4 <= 20 && a5 <= 20)// 6 Zellen Ni an Pin3
    {
        ni_zelle = a3/6;
        check();
    }
    else if(a0 <= 20 && a1 <= 20 && a2 <= 20 && a3 <= 20 && a4 > 2000 && a5 <= 20)// 7 Zellen Ni an Pin4
    {
        ni_zelle = a4/7;
        check();
    }
    else if(a0 <= 20 && a1 <= 20 && a2 <= 20 && a3 <= 20 && a4 <= 20 && a5 > 2000)// 8 Zellen Ni an Pin5
    {
        ni_zelle = a5/8;
        check();
    }
    else if(!flag3 && (a0 <= 20 && a1 <= 20 && a2 <= 20 && a3 <= 20 && a4 <= 20 && a5 <= 20 && a6 > 2000 && a7 <= 20))// 9 Zellen Ni an Pin6
    {
        ni_zelle = a6/9;
        check();
    }
    else if(!flag3 && (a0 <= 20 && a1 <= 20 && a2 <= 20 && a3 <= 20 && a4 <= 20 && a5 <= 20 && a6 <= 20 && a7 > 2000))// 10 Zellen Ni an Pin7
    {
        ni_zelle = a7/10;
        check();
    }

    if(ni_zelle > 0)  
    {
      if(ni_zelle > 1300) 
           digitalWrite(LED_PIN0,HIGH);
      else digitalWrite(LED_PIN0,LOW);
      if(ni_zelle > 1250) 
           digitalWrite(LED_PIN1,HIGH);
      else digitalWrite(LED_PIN1,LOW);
        check();
      if(ni_zelle > 1200) 
           digitalWrite(LED_PIN2,HIGH);
      else digitalWrite(LED_PIN2,LOW);
      if(ni_zelle > 1175) 
           digitalWrite(LED_PIN3,HIGH);
      else digitalWrite(LED_PIN3,LOW);
         check();
      if(ni_zelle < 1150) 
           digitalWrite(TON_PIN,HIGH);
      else digitalWrite(TON_PIN,LOW);
      digitalWrite(LED_PIN4,HIGH);
    }    
    else
    {
       unsigned short ages=10000;
       if(!flag3)
       {
          if(a7 > 20) a7 -= a6;
          else a7=0;  
            check();
          if(a6 > 20) a6 -= a5;
          else a6=0;  
            check();  
       }
        if(a5 > 20) a5 -= a4;
        else a5=0;  
        check();
        if(a4 > 20) a4 -= a3;
        else a4=0;  
        if(a3 > 20) a3 -= a2;
        else a3=0;
        check();
        if(a2 > 20) a2 -= a1;
        else a2=0;  
        if(a1 > 20) a1 -= a0; 
        else a1=0;  
        if(a0 <= 20)a0  =  0;
        check();      
      if(a0 > 20 && ages > (a0+ 2)) ages =  a0-2;
      if(a1 > 20 && ages > (a1+ 3)) ages =  a1-3;
      if(a2 > 20 && ages > (a2+ 5)) ages =  a2-5;
      if(a3 > 20 && ages > (a3+ 6)) ages =  a3-6;
      if(a4 > 20 && ages > (a4+ 8)) ages =  a4-8;
      if(a5 > 20 && ages > (a5+10)) ages = a5-10;
      if(!flag3)
      {
        if(a6 > 20 && ages > (a6+12)) ages = a6-12;
        if(a7 > 20 && ages > (a7+14)) ages = a7-14;        
      }
      if(a0 < 4500)
      if((!flag0 && ages >= 4000) || (flag0 && ages >= 3500)) 
           digitalWrite(LED_PIN0,HIGH);
      else digitalWrite(LED_PIN0,LOW);
        check();
      if((!flag0 && ages >= 3800) || (flag0 && ages >= 3400)) 
           digitalWrite(LED_PIN1,HIGH);
      else digitalWrite(LED_PIN1,LOW);
      if((!flag0 && ages >= 3600) || (flag0 && ages >= 3200)) 
           digitalWrite(LED_PIN2,HIGH);
      else digitalWrite(LED_PIN2,LOW);
        check();
      if((!flag0 && ages >= 3400) || (flag0 && ages >= 3000)) 
           digitalWrite(LED_PIN3,HIGH);
      else digitalWrite(LED_PIN3,LOW);
      if((!flag0 && ages < 3300) || (flag0 && ages < 2800)) 
           digitalWrite(TON_PIN,HIGH);
      else digitalWrite(TON_PIN,LOW);
      digitalWrite(LED_PIN4,HIGH);
         check();
   }
  }
  
  if(flag3) //wenn BMP180 da ist
  {
//  	static uint32_t D1 = 0;
//	static uint32_t D2 = 0;
//	static int64_t dT = 0;
//	static int64_t OFF = 0; 
//	static int64_t SENS = 0; 
//        uint8_t osr = OSR_4096;
	  static long int zeit = millis(), zeit1 = micros();
	  static float H1 = 0;
  	static float vm[MITTEL];
  	static unsigned char ivm = 0;
  	static bool start_b=true;
    static char status;
    static double T=0,P=0,p0=0;

    status = startTemperature();
    if (status != 0)
    {
      for(int i = 0; i < status; i++)
      {
        delay(1);
        check();
      }
      status = getTemperature(T);
      if (status != 0)
      {
        status = startPressure(3);
        if (status != 0)
        {
          for(int i = 0; i < status; i++)
          {
            delay(1);
            check();
          }

          status = getPressure(P,T);
          if (status)
          {
            check();
            temp = T;
            druck = P;
            if(start_b)
            {
              p0 = druck;
              start_b=false;
            }    
	          hoch = (287.05 * (temp + 273.15) * (0.401 * p0/(P)-0.6045 * (P)/p0 + 0.2035))/9.81;	
            check();
 	          if(millis()-zeit > sample)
	          {
		          vm[ivm++] = (hoch-H1)/((float)(millis()-zeit) / 1000.0);
              check();
		          H1 = hoch;
		          zeit = millis();
              check();
		          if(ivm > MITTEL) ivm = 0;
	
              check();

	            v = 0;
	            for(unsigned char i = 0; i < MITTEL ; i++)
	            {
		            v += vm[i];
                check();
	            }
		
	            v_steig = v/(float)MITTEL;
            }
 
  //Debug-Ausgaben 
  
//  Serial.print("Temp.: ");
//  Serial.print(temp,DEC);
//  Serial.print(" - Druck: ");
//  Serial.print(druck,DEC);
//  Serial.print(" - Hoch: ");
//  Serial.print(hoch,DEC);
//  Serial.print(" - Steigen: ");
//  Serial.println(v_steig,DEC);
//  delay(500);
          }  
       // else Serial.println("error retrieving pressure measurement\n");
        }
    //  else Serial.println("error starting pressure measurement\n");
      }
  //  else Serial.println("error retrieving temperature measurement\n");
    }
 // else Serial.println("error starting temperature measurement\n");
  }

}
//---------------------------------------------------------------------------------------
void daten2()
{
  static uint8_t sendebytes_i = 3;
  static int8_t emfangbytes_i = 0, emfangbytesdummy_i = 0, anfrage_i = 0,anfragefdummy_i[6], anfragef_i[6], antwort_i = 0;
  static uint8_t sendung_i[] = {0, 0, 0, 0, 0};
  static int wert_i = 0;
  static float faktor = 1.0;
  static unsigned long zeit1_i=micros();
  unsigned char adresse_i8 = 0, einheit_i8 = 0, adresse_synth_i8 = 0, einheit_synth_i8 = 0;
  int8_t lb_i, hb_i, ae_i;
  static bool blinken_b = false, serial_b=false;
  bool overflow_b = false;

 
  if(Serial.available())
  {
    emfangbytes_i = Serial.readBytes((char*)anfragef_i,1);
    zeit1_i=micros();
    emfangbytesdummy_i = Serial.readBytes((char*)anfragefdummy_i,1);
    
    anfrage_i = anfragef_i[0];
    if((emfangbytes_i == 1) && (emfangbytesdummy_i < 1) && (anfrage_i >= 0) && (anfrage_i <= 15) )
    {
      if(LED_PIN >= 0)  
        digitalWrite( LED_PIN, digitalRead( LED_PIN ) ^ 1 );
      
      switch((byte)wert(GETE,NULL,anfrage_i))
      {
        case 0x00 :  faktor = 1.0;  break;
        case 0x01 :  faktor = 0.1;  break;
        case 0x02 :  faktor = 0.1;  break;
        case 0x03 :  faktor = 0.1;  break;
        case 0x04 :  faktor = 0.1;  break;
        case 0x05 :  faktor = 100;  break;
        case 0x06 :  faktor = 0.1;  break;
        case 0x07 :  faktor = 0.1;  break;
        case 0x08 :  faktor = 1.0;  break;
        case 0x09 :  faktor = 1.0;  break;
        case 0x0A :  faktor = 1.0;  break;
        case 0x0B :  faktor = 1.0;  break;
        case 0x0C :  faktor = 1.0;  break;
        case 0x0D :  faktor = 0.1;  break;
        case 0x0E :  faktor = 1.0;  break;
        case 0x0F :  faktor = 1.0;  break;
        default   :  faktor = 1.0;  break;  
      }

      callback(anfrage_i);
      wert_i = (int)(wert(GETW,NULL,anfrage_i)/faktor);
      //Serial.println(wert_i);
      //Bestimmung des Overflow-Alarms
      if(wert_i < -16384 ||  wert_i > 16383)  overflow_b = true;
      //wert_i=1;
      //Aufteilung des Wertes in Teilbytes
      if((uint8_t)wert(GETE,NULL,anfrage_i)== 0x01 && wert_i==36)//Spannungswaere von +3,6V (36) führen zu Datentranmsferfehlern zwischen Rx u. Tx
      {
          wert_i=35;
      }
      
      lb_i = (uint8_t)(((abs(wert_i) << 1) + (int)overflow_b) & 0x00FF);
      if(wert_i < 0)
      {
        hb_i = (uint8_t)(((abs(wert_i) << 1) & 0xFF00) >> 8) | 0x80;
      }  
      else
        hb_i = (uint8_t)(((abs(wert_i) << 1) & 0xFF00) >> 8);
      ae_i = (uint8_t)((anfrage_i & 0x0F) << 4) + ((uint8_t)wert(GETE,NULL,anfrage_i) & 0x0F);
      

      sendung_i[0] = ae_i ;
      sendung_i[1] = 0xFF & lb_i ;
      sendung_i[2] = 0xFF & hb_i ;
      
      while(micros()-zeit1_i < 1600){;}
      
      Serial.write(sendung_i,3);
     
    } 

  }   //*/
}
//---------------------------------------------------------------------------------------
float werte(float werte, char einheit_i, char index_i)
{
   wert(SETW,werte,index_i);
   wert(SETE,(float)einheit_i,index_i);

}  
//----------------------------------------------------------------------------------------
float wert(char aktion_i, float wert,  char index_i)
{
	static float eingang[16];
	static byte einheit_i[16];
	if((index_i >= 0) &&(index_i < 16 ))
	{
		if((aktion_i == SETW))
		{
			eingang[index_i] = wert;
			return eingang[index_i];
		}  
		if((aktion_i == SETE))
		{
			if(wert > 15) wert = 15;
			if(wert < 0 ) wert = 0;
			einheit_i[index_i] = (byte)wert;
			return einheit_i[index_i];
		}  
		if((aktion_i == GETW))
		{
			return eingang[index_i];
		}  
		if((aktion_i == GETE))
		{
			return einheit_i[index_i];
		}  
    
	}
	else return 0;  
}  
//---------------------------------------------------------------------------------------
