/* ---------------------------------------------------------------------------
** Diese Software ist Public Domain
** keine Garantie auf die Funktion 
** es wird kein weiterer Support gewährleistet
**
** Servo_Schalter.pde
** Fernsteuerbarer 1- Kanal- Schalter / serielle Ausgabe von insgesamt 4 Kanälen zwecks Debugging / späterer Erweiterung
**
** Autor:Roman Radtke
** Benutzte Library: ArduinoRCLib von Daniel van den Ouden
** Website: http://sourceforge.net/p/arduinorclib/
** -------------------------------------------------------------------------*/

// der Text nach den Trennstrichen ist ein Kommentar und wird vom Compiler ignoriert

// das Programm liest prinzipiell 4 Servo Signale von Pins 8 bis 11 ein, was eine spätere Erweiterung vereinfacht
// alle eingelesenen Werte werden zwecks Debugging über die serielle Schnittstelle ausgegeben
// zum Schalten der LED wird nur der an Pin 8 angeslossene Servo Kanal verwendet

// hier werden die von diesem Programm benutzten Libraries eingebunden
#include <ServoIn.h>
#include <Timer1.h>


// Definition und Zuweisung der Variablen, beziehungsweise Übergabe der Konstanten an den Compiler
#define SERVOS 4

uint16_t g_values[SERVOS];                    // Ausgabe Speicherort für die Servo- Werte
uint8_t  g_workIn[SERVOIN_WORK_SIZE(SERVOS)]; // Dies wird benötigt, damit die ServoIn Funktion funktioniert

rc::ServoIn g_ServoIn(g_values, g_workIn, SERVOS); // Eine Routine aus der RC- Library wird initialisiert

// die Setup Prozedur, welche in jedem Programm enthalten sein muss
void setup()
{
	// Timer 1 wird für das Programm benötigt und wird hier initialisiert
	rc::Timer1::init();
	
	// Das Servo Signal, welches die LED schalten soll muss an Digital Pin 8 angeschlossen werden, die Signale an Pins 9, 10, 11 werde ebenfalls eingelesen und seriell ausgegeben
	pinMode(8, INPUT);
	pinMode(9, INPUT);
	pinMode(10, INPUT);
	pinMode(11, INPUT);
        // Die Last (LED) muss an Digital Pin 12 angeschlossen werden
	pinMode(12, OUTPUT);
        // Wenn das Programm gestartet wird ist die LED erstmal an (vorausgesetzt es liegt kein Servosignal an Pin 8 an, welches die LED sofort ausschaltet)
        digitalWrite (12, HIGH);
	
	// Um Änderungen an den Pins zu erkennen werden Pin Change Interrupts verwendet
	
	// Es werden die Pin Change Interrupts für PB0-3 verwendet (entsprechen den Digital Pins 8-11)
	PCMSK0 = (1 << PCINT0) | (1 << PCINT1) | (1 << PCINT2) | (1 << PCINT3);
	
	// Aktivieren des Pin Change Interrupts 0
	PCICR = (1 << PCIE0);
	
	// Beginne das Überwachen der Pins
	g_ServoIn.start();

// Initialisieren der seriellen Schnittstelle zwecks Debugging
      Serial.begin(57600);   // Baudrate von 57600
}

// ab hier die Loop Prozedur, welche ebenfalls in jedem Programm enthalten sein muss
void loop()
{
	// Einlesen der hereinkommenden Werte
	g_ServoIn.update();
	
	// ab hier wird festgelegt, was mit den nun in g_values gespeicherten Servo- Werten passieren soll

        // serielle Ausgabe der 4 eingelesenen Kanäle mit 57600 baud
Serial.print(g_values[0]);
Serial.println();
Serial.print(g_values[1]);
Serial.println();
Serial.print(g_values[2]);
Serial.println();
Serial.print(g_values[3]);
Serial.println();
Serial.println("*******************************************");

        // Auswertung der 1. Servo- Eingangs an Digital- Pin 8, wenn Wert kleiner als 1400 geht die LED an, falls er grösser als 1600 ist, wieder aus
if (g_values[0] < 1400) digitalWrite (12, HIGH);
if (g_values[0] > 1600) digitalWrite (12, LOW);
}


// Ab hier folgt der Code, welcher für das Handling der Interrupts zuständig ist- dieser ist relativ komplex und sollte daher nicht verändert werden

static uint8_t lastB = 0;

ISR(PCINT0_vect)
{
	uint8_t newB = PINB;
	uint8_t chgB = newB ^ lastB;
	lastB = newB;
	
	// Hat sich einer der Werte verändert?
	if (chgB)
	{
		// Wenn ja- welcher?
		if (chgB & _BV(0))
		{
			g_ServoIn.pinChanged(0, newB & _BV(0));
		}
		if (chgB & _BV(1))
		{
			g_ServoIn.pinChanged(1, newB & _BV(1));
		}
		if (chgB & _BV(2))
		{
			g_ServoIn.pinChanged(2, newB & _BV(2));
		}
		if (chgB & _BV(3))
		{
			g_ServoIn.pinChanged(3, newB & _BV(3));
		}
	}
}
